/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network.config;

import com.ibm.hwmca.base.settings.SettingsConstants;
import java.io.Serializable;

public class NetworkInterfaceConfig
implements Serializable,
SettingsConstants {
    private static final String TRACE_MASKT = "XSETNCFT";
    private static final String TRACE_MASKF = "XSETNCFF";
    private static final String TRACE_MASKD = "XSETNCFD";
    private String interfaceID = "";
    private int interfaceType = 2;
    private int addressType = 3;
    private boolean visible = true;
    private boolean lparCommunication = false;

    public NetworkInterfaceConfig() {
    }

    public NetworkInterfaceConfig(String interfaceID, int interfaceType, int addressType, boolean visible, boolean lparCommunication) {
        this.setInterfaceID(interfaceID);
        this.setInterfaceType(interfaceType);
        this.setAddressType(addressType);
        this.setVisible(visible);
        this.setLparCommunication(lparCommunication);
    }

    public String getInterfaceID() {
        return this.interfaceID;
    }

    public void setInterfaceID(String interfaceID) {
        this.interfaceID = interfaceID;
    }

    public int getInterfaceType() {
        return this.interfaceType;
    }

    public void setInterfaceType(int interfaceType) {
        this.interfaceType = interfaceType;
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int addressType) {
        this.addressType = addressType;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isLparCommunication() {
        return this.lparCommunication;
    }

    public void setLparCommunication(boolean lparCommunication) {
        this.lparCommunication = lparCommunication;
    }

    public String toString() {
        String addressString;
        String interfaceString;
        switch (this.interfaceType) {
            case 0: {
                interfaceString = "fixed_public";
                break;
            }
            case 1: {
                interfaceString = "fixed_private";
                break;
            }
            case 2: {
                interfaceString = "customer_choice";
                break;
            }
            default: {
                interfaceString = this.interfaceType + "???";
            }
        }
        switch (this.addressType) {
            case 0: {
                addressString = "fixed";
                break;
            }
            case 1: {
                addressString = "dhcp_client";
                break;
            }
            case 2: {
                addressString = "dhcp_server";
                break;
            }
            case 3: {
                addressString = "customer_choice";
                break;
            }
            default: {
                addressString = this.addressType + "???";
            }
        }
        return this.interfaceID + ", it:" + interfaceString + ", at:" + addressString + ", vis:" + this.visible + ", lpar:" + this.lparCommunication;
    }
}

